//--------------------------------------------------------------------------------------
float4x4 g_mWVP : worldviewprojection;
float3	 g_LightDir : light0;
float3	 g_LightColor : lightcolor0;
texture  g_Diffuse0 : diffuse0;
float4x4 g_Anime[22] : animation;

//--------------------------------------------------------------------------------------
sampler MeshTextureSampler = 
sampler_state
{
    Texture = <g_Diffuse0>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position 
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV  : TEXCOORD0;  // vertex texture coords 
};

//--------------------------------------------------------------------------------------
VS_OUTPUT RenderSceneVS( float3 vPos : POSITION, 
                         float3 vNormal : NORMAL,
                         float4 vDiffuse : COLOR0,
                         float2 vTexCoord0 : TEXCOORD0)
{
    VS_OUTPUT Output;
    
	Output.Position = mul(g_mWVP, float4(vPos, 1.0f));

	float4 destnormal = float4(vNormal, 1.0f);
	float3 Light0 = -normalize(g_LightDir);
	float4 lightVec = float4(Light0, 1.0f);
	float4 col = dot(destnormal, lightVec);

	Output.Diffuse = col * vDiffuse;
	Output.Diffuse.a = 1.0f;

	Output.TextureUV = vTexCoord0; 

    return Output;    
}

//--------------------------------------------------------------------------------------
VS_OUTPUT RenderAnimatedSceneVS( float3 vPos : POSITION, 
                         float3 vNormal : NORMAL,
                         float4 vDiffuse : COLOR0,
					     float4 vBlen : BLENDWEIGHT,
                         float2 vTexCoord0 : TEXCOORD0)
{
    VS_OUTPUT Output;

	float weight0 = vBlen.x;
	float weight1 = vBlen.y;

	float index0 = vBlen.z;
	float index1 = vBlen.w;

	float4 temp = float4(vPos.x, vPos.z, vPos.y, 1.0);

	float3 pos = weight0 * mul(temp, g_Anime[index0]);
    pos = pos + weight1 * mul(temp, g_Anime[index1]);

	Output.Position = mul(g_mWVP, float4(pos, 1.0f));

	float4 destnormal = float4(vNormal, 1.0f);
	float3 Light0 = -normalize(g_LightDir);
	float4 lightVec = float4(Light0, 1.0f);
	float4 col = dot(destnormal, lightVec);

	Output.Diffuse = col * vDiffuse;
	Output.Diffuse.a = 1.0f;

	Output.TextureUV = vTexCoord0; 

    return Output;    
}


//--------------------------------------------------------------------------------------
float4 RenderScenePS(VS_OUTPUT In) : COLOR
{ 
    return tex2D(MeshTextureSampler, In.TextureUV) * In.Diffuse;
}

//--------------------------------------------------------------------------------------
technique RenderSceneWithTexture1Light
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS();
        PixelShader  = compile ps_2_0 RenderScenePS();
    }
}

//--------------------------------------------------------------------------------------
technique Animated // special keyword to mention technique used when it's an animated object
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderAnimatedSceneVS();
        PixelShader  = compile ps_2_0 RenderScenePS();
    }
}
